function [nele,edofMat,ndof]=PRE_HOMOGENIZATION(nelx,nely,nelz)
nele=nelx*nely*nelz;
nodegrd=reshape(1:(nely+1)*(nelx+1),nely+1,nelx+1);
nodeids=reshape(nodegrd(1:end-1,1:end-1),nely*nelx,1);
nodeidz=0:(nely+1)*(nelx+1):(nelz-1)*(nely+1)*(nelx+1);
nodeids=repmat(nodeids,size(nodeidz))+repmat(nodeidz,size(nodeids));
edofVec=3*nodeids(:)+1;
edofMat=repmat(edofVec,1,24)+ ...
    repmat([0 1 2 3*nely + [3 4 5 0 1 2] -3 -2 -1 ...
    3*(nely+1)*(nelx+1)+[0 1 2 3*nely + [3 4 5 0 1 2] -3 -2 -1]],nele,1);
%% IMPOSE PERIODIC BOUNDARY CONDITIONS
% Use original edofMat to index into list with the periodic dofs
nn=(nelx+1)*(nely+1)*(nelz+1); % Total number of nodes
nnP=(nelx)*(nely)*(nelz);    % Total number of unique nodes
nnPArray=reshape(1:nnP, nely, nelx,nelz);
% % Extend with a mirror of the top border
nnPArray(end+1,:)=nnPArray(1,:);
% % Extend with a mirror of the left border
nnPArray(:,end+1,:)=nnPArray(:,1,:);
% % Extend with a mirror of the back border
nnPArray(:,:,end+1)=nnPArray(:,:,1);
% % Make a vector into which we can index using edofMat:
dofVector=zeros(3*nn,1);
dofVector(1:3:end)=3*nnPArray(:)-2;
dofVector(2:3:end)=3*nnPArray(:)-1;
dofVector(3:3:end)=3*nnPArray(:);
edofMat=dofVector(edofMat);
ndof=3*nnP;